// Top Secret Crypto Gold for Windows
//...................................

// Copyright  2000 - 2005 by TAN$TAAFL Software Company
//						      14 Foster St., Banician
//                            Olongapo City 2200
//                            Philippines

// This source code is NOT IN THE PUBLIC DOMAIN and is NOT OPEN SOURCE.
// It is provided solely for the purpose of letting you determine how
// the program works, and that there are no backdoors or hidden code
// in the program. Anyone that wants to use any portion of this code
// in their own program please contact the author at:

//							  MacGregor K. Phillips
//                            PSC 517 Box RS
//                            FPO AP 96517-1000

// Procedures for e-mail transformation, extraction, and
// reconstruction.
//......................................................
#include <windows.h>  
#include "Tsc.h"
#include "ContextHelp.h"
#include "Prototypes.h"
#include <Shlwapi.h>
#include <Commctrl.h>
#include <htmlhelp.h>
#include <shellapi.h>
#include <shlobj.h>
#include "Tscmsg.h"
#include "Check.h"
#define STRSAFE_LIB
#include <strsafe.h>

extern	DWORD				dwStringSafeFlag;
extern	HINSTANCE			hInst;
extern	LPTSTR				lpszNA;
extern	HWND				hMainWindow;
extern	LPCTSTR				lpszAppName;
extern	LPCTSTR				lpIconPointer;
extern	HWND				hDialogModeLess;
extern	HWND				hDlgCurrent;
extern	BOOL				bProcessInProgress;
extern	BOOL				bCancelOperation;
extern	LPBYTE				lpFileName;
extern	LPBYTE				lpFileExtension;
extern	HICON				hIcon;
extern	TCHAR				szDestination[MAX_PATH];
extern	LPTSTR				lpszDateTimeFormat;
extern	LPTSTR				lpszSizeFormat;
extern	NUMBERFMT			nFormatInfo;
extern	LPBYTE				lpCrc32Table;
extern	int					iWhichAviClip;
extern	int					iStepIncrement;
extern	BOOL				bAviClipOK;
extern	HWND				hAviClip;
extern	LPBYTE				lpSearchEDI;
extern	SHFILEINFO			shfi1;
extern	LPCD_STRUCT			lpSecretKeyCentralDir;
extern	BOOL				bUseNew;
extern	TCHAR				szPreviousDestinationDir;
extern	LPTSTR				lpMyCmdLine;
extern	BOOL				bWin2000OrGreater;
extern	HFONT				hDlgFont;
extern	HFONT				hDlgFont2;

// Variables for the e-mail procedures.
//.....................................
BYTE			TransTable[] = {"+ABCDEFGHIJKLMNOPQRSTUVWXYZ/0123"\
								"4abcdefghijklmnopqrstuvwxyz56789"};

BYTE			ReconTable[] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,\
								 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,\
								 0, 0, 0, 0, 0, 0, 0, 0,\
								 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,\
								 0, 0, 0,27,28,29,30,31,32,59,60,61,\
							    62,63, 0, 0, 0, 0, 0, 0, 0, 1, 2, 3,\
								 4, 5, 6, 7, 8, 9,10,11,12,13,14,15,\
								16,17,18,19,20,21,22,23,24,25,26, 0,\
								 0, 0, 0, 0, 0,33,34,35,36,37,38,39,\
								40,41,42,43,44,45,46,47,48,49,50,51,\
								52,53,54,55,56,57,58};

DWORD			DivideTable[] = {-1, 7680, 15360, 23040, 30720, 38400,\
							     46080};

TCHAR			szXFormFile[MAX_PATH];
DWORD			dwSizeSelect;
TCHAR			szR64FileExt[] = ".xxx.r64";
TCHAR			szR64ExtDup[] = ".001.r64";
TCHAR			szHeaderId[] = "+HR64+";
HANDLE			hOutPutFile;
LPBYTE			lpR64TempIn;
LPBYTE			lpR64TempOut;
LPBYTE			lpDestinationFileName;
LPBYTE			lpDestinationExt;
DWORD			dwHoldArea;
int				iBitsInHoldArea;
DWORD			dwStuffR64Index;
DWORD			dwCount64;
DWORD			dwTotalBytes;
BOOL			bEndOfRecon;
DWORD			dwCheckCrc;
DWORD			dwCrcOk;
DWORD			dwCrcBad;
BOOL			bWipeAfterXform;
BOOL			bWipeAfterExtr;

// Ending header of CR LF +HR64END+ CR LF.
//........................................
TCHAR			szEndId[] = {13, 10, 43, 72, 82, 54, 52, 69, 78, 68, 43, 13, 10};

TCHAR			szTrailer[] = {13, 10, 13, 10};

TCHAR			szStatusFormat[] = "%u out of %u files passed their integrity checks.";

// File header information for each transformed file.
//...................................................
R64_HEADER		FileInfoHeader;

// Expanded header.
//.................
EXP_R64_HEADER	ExpandedHeader;

// Transform a file for e-mail transmission.
//..........................................
VOID TransformForEmail()
{
	ULARGE_INTEGER	uliFreeCallerBytes;
	ULARGE_INTEGER	uliTotalBytes;
	ULARGE_INTEGER	uli;
	OPENFILENAME	ofn;
	DWORD			dwOldHelpTopic;
	HANDLE			hXFormFile = 0;
	LPBYTE			lpInBuffer = 0;
	LPBYTE			lpOutBuffer = 0;
	LPBYTE			lpAppendPointer;
	LPBYTE			lpOutPutFileName;
	BOOL			bResult;
	int				iResult;
	HRESULT			hr = ERROR_SUCCESS;
	UINT			uiDriveType;
	DWORD			dwPathLength;
	DWORD			dwFilesToMake;
	DWORD			dwBytesRead;
	DWORD			dwBytesWritten;
	BOOL			bDiskError = TRUE;
	TCHAR			szRoot[16];
	BROWSEINFO		bi;
    LPITEMIDLIST	lpidl;
    LPMALLOC		lpMalloc;
	BY_HANDLE_FILE_INFORMATION	fi;

	bProcessInProgress = TRUE;
	dwOldHelpTopic = ChangeHelpTopic(IDH_TRANSFORM);
	bAviClipOK = FALSE;
	bWipeAfterXform = FALSE;

	ZeroMemory(&FileInfoHeader,sizeof(R64_HEADER));

	// Initialize the OPENFILENAME structure.
	//.......................................
	InitializeOFN(&ofn,SAVE_SOURCE);

	// Initialize with specific information for this procedure.
	//.........................................................
	ofn.lpstrFile = szXFormFile;
	ofn.nMaxFile = sizeof(szXFormFile);
	ofn.hwndOwner = hMainWindow;
	ofn.hInstance = hInst;
	ofn.lpstrFilter = TEXT("All Files [*.*]\0*.*\0Tscg Files [.rng;.rsakey;.tsc;.otp;.pad;.tsig;.jrl]\0*.rng;*.rsakey;*.tsc;*.otp;*.pad;*.tsig;*.jrl\0Compressed Files [.pkd;.lha;.zip;.arj;.cab]\0*.pkd;*.lha;*.zip;*.arj;*.cab\0Executable Files [.exe;.dll;.ocx]\0*.exe;*.dll;*.ocx\0Image Files [.bmp;.dib;.gif;.jpg;,ico;,cur]\0*.bmp;*.dib;*.gif;*.jpg;*.ico;*.cur\0Word Documents [.doc]\0*.doc\0Web Pages [.htm;.html;.mht]\0*.htm;*.html;*.mht\0Email Files [.eml]\0*.eml\0Rich Text Format [.rtf]\0*.rtf\0Text Files [.txt]\0*.txt\0Lotus 1-2-3 [.wk1;.wk3]\0*.wk1;*.wk3\0Microsoft Excel Worksheet [.xls;.xlw]\0*.xls;*.xlw\0Windows Write [.wri]\0*.wri\0WordPerfect 5.x [.doc]\0*.doc\0WordPerfect 6.x [.wpd;.doc]\0*.wpd;*.doc\0");
	ofn.nFilterIndex = 1;
	ofn.lpstrTitle = TEXT("Select a File to Transform for E-Mail Transmission");
	ofn.Flags = (OFN_EXPLORER | OFN_FILEMUSTEXIST | OFN_PATHMUSTEXIST |
		         OFN_ENABLEHOOK | OFN_ENABLESIZING | OFN_HIDEREADONLY |
				 OFN_SHOWHELP | OFN_ENABLETEMPLATE);
	ofn.lpstrDefExt = NULL;
	if (bWin2000OrGreater)
	{
		ofn.lpTemplateName = TEXT("WIPEAFTERXFORMNEW");
	}
	else
	{
		ofn.lpTemplateName = TEXT("WIPEAFTERXFORM");
	}
	ofn.lpfnHook = MyXformOFNHookProc;

	// Setup the icon to use in the caption bar.
	//..........................................
	lpIconPointer = lpszAppName;

	// Always 1 for this procedure.
	//.............................
	iStepIncrement = 1;

	// Now select a file to transform for e-mail transmission.
	//........................................................
	while(TRUE)
	{
		ZeroMemory(&szXFormFile,sizeof(szXFormFile));

		if (!GetOpenFileName(&ofn))
		{
			CommDlgBoxErrorProc(IDS_GET_FILES);
			goto XFormEnd;
		}
		SaveDirName((LPBYTE)&szXFormFile,SAVE_SOURCE,TRUE);

		// Open the file and get its file size.
		//.....................................
		lpFileName = PathFindFileName((LPCTSTR)&szXFormFile);
		lpFileExtension = PathFindExtension((LPCTSTR)&szXFormFile);
		hXFormFile = CreateMyFile((LPTSTR)&szXFormFile,GENERIC_READ,0,NULL,
								   OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
		if (!hXFormFile)
		{
			goto XFormEnd;
		}
		bResult = GetFileInformationByHandle(hXFormFile,&fi);
		if (!bResult)
		{
			ErrorProcedure((LPTSTR)&szXFormFile,IDS_GETFILEINFO,MB_OK);
			goto XFormEnd;
		}
		FileInfoHeader.ACCESSED = fi.ftLastAccessTime;
		FileInfoHeader.ATTRIBUTES = fi.dwFileAttributes;
		FileInfoHeader.CREATION = fi.ftCreationTime;
		FileInfoHeader.WRITTEN = fi.ftLastWriteTime;
		FileInfoHeader.uliFileSize.LowPart = fi.nFileSizeLow;
		FileInfoHeader.uliFileSize.HighPart = fi.nFileSizeHigh;

		EmptyTheMessageQue();

		// See if the file is to large for our purposes.
		//..............................................
		if (FileInfoHeader.uliFileSize.QuadPart > 46033920)
		{
			SetLastError(IDS_XFORMTOOBIG);
			ErrorProcedure((LPTSTR)&szXFormFile,IDS_GETFILESIZE,MB_OK);
			if (hXFormFile)
			{
				bResult = CloseMyHandle((LPTSTR)&szXFormFile,hXFormFile);
				if (!bResult)
				{
					goto XFormEnd;
				}
				hXFormFile = 0;
			}
			continue;
		}
		bResult = CloseMyHandle((LPTSTR)&szXFormFile,hXFormFile);
		if (!bResult)
		{
			goto XFormEnd;
		}
		hXFormFile = 0;
		break;
	}
	// Get the destination for the transformed files.
	//...............................................
	while(TRUE)
	{
		SetCurrentDirectory((LPCTSTR)&szPreviousDestinationDir);
		ZeroMemory(&szDestination,sizeof(szDestination));

		if (SUCCEEDED(SHGetMalloc(&lpMalloc))) 
		{
			ZeroMemory(&bi,sizeof(bi));
			bi.hwndOwner = hMainWindow;
			bi.pszDisplayName = 0;
			bi.lpszTitle = TEXT("Select a Destination for the Transformed File(s).");
			bi.pidlRoot = 0;
			bi.ulFlags = BIF_RETURNONLYFSDIRS;

			// If we can use the new style of the dialog box, do it.
			//......................................................
			if (bUseNew)
			{
				hr = CoInitialize(NULL);
				if (SUCCEEDED(hr))
				{
					bi.ulFlags |= BIF_NEWDIALOGSTYLE;
				}
			}
			bi.lpfn = BrowseCallbackProc;

			lpidl = SHBrowseForFolder(&bi);

			if (bUseNew && SUCCEEDED(hr))
			{
				CoUninitialize();
			}
			if (lpidl) 
			{
				bResult = SHGetPathFromIDList(lpidl,(LPSTR)&szDestination);
				lpMalloc->lpVtbl->Free(lpMalloc,lpidl);
				lpMalloc->lpVtbl->Release(lpMalloc);
			}
			else
			{
				// We cancelled out.
				//..................
				goto XFormEnd;
			}
			SaveDirName((LPBYTE)&szDestination,SAVE_DESTINATION,FALSE);

			// See if we have any free disk space. cd rom drives that
			// are not writable will report zero.
			//.......................................................
			ZeroMemory(&szRoot,sizeof(szRoot));
			CopyMemory(&szRoot,&szDestination,3);
			bResult = GetDiskFreeSpaceEx((LPCTSTR)&szRoot,
										(PULARGE_INTEGER)&uliFreeCallerBytes.QuadPart,
										(PULARGE_INTEGER)&uliTotalBytes.QuadPart,NULL);
			if (!bResult)
			{
				ErrorProcedure((LPTSTR)&szDestination,IDS_GETFREEDSKSPACE,MB_OK);
				goto XFormEnd;
			}
			if (uliFreeCallerBytes.QuadPart == 0)
			{
				SetLastError(IDS_NOSPACE);
				ErrorProcedure((LPTSTR)&szDestination,IDS_GETFREEDSKSPACE,MB_OK);
				continue;
			}
			// Get the drive type so we can determine which avi
			// clip to use.
			//.................................................
			uiDriveType = GetDriveType((LPCTSTR)&szRoot);

			// Make sure that the destination and file name fit
			// into a file specification. Must have room for 
			// our file extension of a number and r64 to be
			// appended to the original filename. The original
			// filename keeps its extension.
			//.................................................
			PathAddBackslash((LPTSTR)&szDestination);
			dwPathLength = lstrlen((LPCTSTR)&szDestination) + lstrlen((LPCTSTR)lpFileName) + 9;
			if (dwPathLength > MAX_PATH)
			{
				SetLastError(IDS_PATHTOOLONG);
				ErrorProcedure((LPTSTR)&szDestination,IDS_BROWSEFORFOLDER,MB_OK);
				continue;
			}
			// Determine which avi clip to use: file copy, file disk,
			// or file cd rom.
			//.......................................................
			iWhichAviClip = FILE_COPY;
			if (uiDriveType == DRIVE_REMOVABLE && 
			   (*szDestination == 0x41 || *szDestination == 0x61 || 
			    *szDestination == 0x42 || *szDestination == 0x62))
			{
				iWhichAviClip = FILE_DISK;
			}
			else if (uiDriveType == DRIVE_CDROM)
			{
				iWhichAviClip = FILE_CDROM;
			}
			// If we got this far with no error, we have a valid
			// destination.
			//..................................................
			break;
		}
		else
		{
			MessageBoxProc(hMainWindow,IDS_SYSTEM_ERROR,IDS_SELECTDIR,
						   MB_ICONHAND | MB_OK,MB_ICONHAND,0);
			goto XFormEnd;
		}
	}
	// Allocate memory for our two buffers.
	//.....................................
	lpInBuffer = AllocateMemory(BUFFER_SIZE_IN);
	lpOutBuffer = AllocateMemory(BUFFER_SIZE_OUT);
	if (!lpInBuffer || !lpOutBuffer)
	{
		goto XFormEnd;
	}
	// Select the file size we want to break the file into.
	//.....................................................
	iResult = DialogBox(hInst,TEXT("TRANSFORMSIZE"),hMainWindow,(DLGPROC)TransformSizeProc);

	EmptyTheMessageQue();

	// See if we had a system error in creating the dialog box.
	//.........................................................
	if (iResult == -1)
	{
		ErrorProcedure(lpszNA,IDS_CREATEDIALOGBOX,MB_OK);
		goto XFormEnd;
	}
	// Destroy the icon if we used it.
	//................................
	if (hIcon)
	{
		DestroyIcon(hIcon);
		hIcon = 0;
	}
	// Quit if we canceled.
	//.....................
	if (iResult == IDCANCEL)
	{
		goto XFormEnd;
	}
	// Calculate the number of files to make.
	//.......................................
	if (dwSizeSelect == BUFFER_SIZE_IN)
	{
		dwFilesToMake = 1;
	}
	else
	{
		__asm
		{
			xor		edx,edx
			mov		eax,FileInfoHeader.uliFileSize.LowPart
			mov		ecx,dwSizeSelect
			div		ecx
			cmp		edx,0
			je		L1
			inc		eax
		L1:	mov		dwFilesToMake,eax
		}
	}
	FileInfoHeader.TOTAL_FILES = dwFilesToMake;

	// Check to see if we have enough room on the destination
	// drive to hold the files we will create.
	//.......................................................
	uliTotalBytes.QuadPart = ((FileInfoHeader.uliFileSize.QuadPart*8)/6);
	uliTotalBytes.QuadPart += (((uliTotalBytes.QuadPart/64)*66) - uliTotalBytes.QuadPart);
	uliTotalBytes.QuadPart += (dwFilesToMake * sizeof(EXP_R64_HEADER));
	uliTotalBytes.QuadPart += 100;

	if (uliTotalBytes.QuadPart > uliFreeCallerBytes.QuadPart)
	{
		SetLastError(IDS_NOTRANSFORMROOM);
		ErrorProcedure((LPTSTR)&szDestination,IDS_GETFREEDSKSPACE,MB_OK);
		goto XFormEnd;
	}
	// Setup the expanded header.
	//...........................
	CopyMemory(&ExpandedHeader.HEADER,&szHeaderId,lstrlen((LPCTSTR)szHeaderId));
	CopyMemory(&ExpandedHeader.TRAILER,&szTrailer,sizeof(szTrailer));

	if (lpSecretKeyCentralDir != 0)
	{
		MessageBox(hMainWindow,TEXT("One"),TEXT("Debug"),MB_OK);
	}
	// Setup our R64 file extension.
	//..............................
	CopyMemory(&szR64FileExt,&szR64ExtDup,lstrlen((LPCTSTR)szR64ExtDup));

	// Start setting up some values in the header.
	//............................................
	FileInfoHeader.THIS_FILE_NO = 1;
	FileInfoHeader.FILE_CRC = -1;

	// Open the file to be transformed.
	//.................................
	hXFormFile = CreateMyFile((LPTSTR)&szXFormFile,GENERIC_READ,0,NULL,
							   OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
	if (!hXFormFile)
	{
		goto XFormEnd;
	}
	// Setup the name of the first file to create.
	//............................................
	StringCbCatEx((LPTSTR)&szDestination,sizeof(szDestination),(LPCTSTR)lpFileName,NULL,
				   NULL,dwStringSafeFlag);
	lpAppendPointer = (LPBYTE)&szDestination;
	iResult = lstrlen((LPCTSTR)&szDestination);
	lpAppendPointer += iResult;
	StringCbCatEx((LPTSTR)&szDestination,sizeof(szDestination),(LPCTSTR)&szR64FileExt,NULL,
				   NULL,dwStringSafeFlag);
	lpOutPutFileName = PathFindFileName((LPCTSTR)&szDestination);

	// Create the first output file.
	//..............................
	hOutPutFile = CreateMyFile((LPTSTR)&szDestination,GENERIC_READ | GENERIC_WRITE,0,
						        NULL,CREATE_NEW,FILE_ATTRIBUTE_NORMAL,NULL);
	if (!hOutPutFile)
	{
		goto XFormEnd;
	}
	// Put the output file name in the header.
	//........................................
	ZeroMemory(&FileInfoHeader.THIS_FILE,sizeof(FileInfoHeader.THIS_FILE));
	CopyMemory(&FileInfoHeader.THIS_FILE,lpOutPutFileName,lstrlen((LPCTSTR)lpOutPutFileName));

	// Build the crc32 table.
	//.......................
	bResult = Crc32Table(BUILD_TABLE);
	if (!bResult)
	{
		goto XFormEnd;
	}
	// Setup our modeless dialog box.
	//...............................
	bCancelOperation = FALSE;
	hDialogModeLess = CreateDialog(hInst,TEXT("TRANSFORM"),hMainWindow,(DLGPROC)TransformProc);

	if (!hDialogModeLess)
	{
		ErrorProcedure(lpszNA,IDS_CREATEDIALOGBOX,MB_OK);
		goto XFormEnd;;
	}
	// Start the avi clip.
	//....................
	if (bAviClipOK)
	{
		bAviClipOK = Animate_Play(hAviClip,0,-1,-1);
	}
	dwHoldArea = 0;
	iBitsInHoldArea = 0;
	dwStuffR64Index = 0;
	dwCount64 = 0;
	FileInfoHeader.NUMBER_64_BLOCKS = 0;
	FileInfoHeader.LAST_BLOCK_SIZE = 0;

	// Setup temporary vectors for the input and output buffers.
	//..........................................................
	lpR64TempIn = lpInBuffer;
	lpR64TempOut = lpOutBuffer;

	// Go into a loop and create the transformed files.
	//.................................................
	while(dwFilesToMake != 0)
	{
		EmptyTheMessageQue();
		if (bCancelOperation == TRUE)
		{
			break;
		}
		if (FileInfoHeader.TOTAL_FILES < 10)
		{
			Sleep(250);
		}
		// Write a blank header for the file.
		//...................................
		bResult = WriteMyFile((LPTSTR)&szDestination,hOutPutFile,
							  &ExpandedHeader,sizeof(ExpandedHeader),&dwBytesWritten,NULL);
		if (!bResult)
		{
			goto XFormEnd;
		}
		// Read in a portion of the file to transform.
		//............................................
		bResult = ReadMyFile((LPTSTR)&szXFormFile,hXFormFile,lpInBuffer,
							  dwSizeSelect,&dwBytesRead,NULL);
		if (!bResult)
		{
			goto XFormEnd;
		}
		bResult = ConvertToR64((LPBYTE)&szDestination,hOutPutFile,dwBytesRead,TRUE);
		if (!bResult)
		{
			goto XFormEnd;
		}
		if (bCancelOperation == TRUE)
		{
			break;
		}
		// Perform the close out procedure for this file.
		//...............................................
		bResult = StuffR64((LPBYTE)&szDestination,hOutPutFile,0,CLOSE,FALSE);
		if(!bResult)
		{
			goto XFormEnd;
		}
		EmptyTheMessageQue();
		if (bCancelOperation == TRUE)
		{
			break;
		}
		// Write the file end signature.
		//..............................
		bResult = WriteMyFile((LPTSTR)&szDestination,hOutPutFile,
							  &szEndId,sizeof(szEndId),&dwBytesWritten,NULL);
		if (!bResult)
		{
			goto XFormEnd;
		}
		// Finalize the crc32 check value.
		//................................
		__asm
		{
			mov		eax,FileInfoHeader.FILE_CRC
			xor		eax,-1
			mov		FileInfoHeader.FILE_CRC,eax
		}
		// Expand the file header for reprinting of the final values.
		//...........................................................
		dwHoldArea = 0;
		iBitsInHoldArea = 0;
		dwCount64 = 6;
		dwStuffR64Index = 6;
		lpR64TempIn = (LPBYTE)&FileInfoHeader;
		lpR64TempOut = (LPBYTE)&ExpandedHeader;

		// Convert the file information header.
		//.....................................
		bResult = ConvertToR64(NULL,NULL,sizeof(R64_HEADER),FALSE);
		if (!bResult)
		{
			goto XFormEnd;
		}
		if (bCancelOperation == TRUE)
		{
			break;
		}
		uli.QuadPart = 0;
		uli.QuadPart = SetMyFilePointer((LPTSTR)&szDestination,
										hOutPutFile,uli.QuadPart,FILE_BEGIN);
		if (uli.QuadPart == -1)
		{
			goto XFormEnd;
		}
		bResult = WriteMyFile((LPTSTR)&szDestination,hOutPutFile,
							  &ExpandedHeader,sizeof(EXP_R64_HEADER),
							  &dwBytesWritten,NULL);
		if (!bResult)
		{
			goto XFormEnd;
		}
		// Close our file.
		//................
		bResult = CloseMyHandle((LPTSTR)&szDestination,hOutPutFile);
		if (!bResult)
		{
			goto XFormEnd;
		}
		hOutPutFile = 0;

		// Display the name of the transformed file in the
		// dialog box.
		//................................................
		SetDlgItemTextFmt(hDialogModeLess,IDC_FILE2,
						 (LPCTSTR)GetDisplayName(&shfi1,(LPCTSTR)&szDestination));

		// Update the progress bar.
		//.........................
		SendMessage(GetDlgItem(hDialogModeLess,IDC_PROGRESS),PBM_STEPIT,0,0);

		// Setup the process for the next file for the group
		// if files left is greater than 1.
		//..................................................
		if (dwFilesToMake > 1)
		{
			FileInfoHeader.THIS_FILE_NO++;
			FileInfoHeader.FILE_CRC = -1;
			dwHoldArea = 0;
			iBitsInHoldArea = 0;
			dwStuffR64Index = 0;
			dwCount64 = 0;
			FileInfoHeader.NUMBER_64_BLOCKS = 0;
			FileInfoHeader.LAST_BLOCK_SIZE = 0;

			// Reset the input/output vectors.
			//................................
			lpR64TempIn = lpInBuffer;
			lpR64TempOut = lpOutBuffer;

			// Setup the next number for the output file.
			//...........................................
			__asm
			{
				mov		edi,offset szR64FileExt
				inc		byte ptr [edi+3]
				cmp		byte ptr [edi+3],0x3a
				jne		L2
				mov		byte ptr [edi+3],'0'
				inc		byte ptr [edi+2]
			L2:	cmp		byte ptr [edi+2],0x3a
				jne		L3
				mov		byte ptr [edi+2],'0'
				inc		byte ptr [edi+1]
			L3:
			}
			CopyMemory(lpAppendPointer,&szR64FileExt,sizeof(szR64FileExt));

			hOutPutFile = CreateMyFile((LPTSTR)&szDestination,GENERIC_READ | GENERIC_WRITE,0,
									   NULL,CREATE_NEW,FILE_ATTRIBUTE_NORMAL,NULL);
			if (!hOutPutFile)
			{
				goto XFormEnd;
			}
			// Put the new output file name in the header.
			//............................................
			ZeroMemory(&FileInfoHeader.THIS_FILE,sizeof(FileInfoHeader.THIS_FILE));
			CopyMemory(&FileInfoHeader.THIS_FILE,lpOutPutFileName,
					   lstrlen((LPCTSTR)lpOutPutFileName));
		}
		dwFilesToMake--;
	}
	// Set the position of the progress bar to 100% if we did not quit
	// or exit with an error
	//................................................................
	if (!bCancelOperation)
	{
		SendMessage(GetDlgItem(hDialogModeLess,IDC_PROGRESS),PBM_SETPOS,
							  (WPARAM)FileInfoHeader.TOTAL_FILES,0);
		bDiskError = FALSE;
	}
	// Make sure bCancelOperation is set to FALSE.
	//............................................
	bCancelOperation = FALSE;

	// Stop the avi clip.
	//...................
	if (bAviClipOK)
	{
		bAviClipOK = Animate_Stop(hAviClip);
	}
	// Change the cancel button to ok.
	//................................
	SetDlgItemText(hDialogModeLess,IDCANCEL,TEXT("&OK"));

	FlashMyIcon(TRUE);

	// Wait until we close the dialog box to exit.
	//............................................
	while(TRUE)
	{
		CheckForMessages();
		if (bCancelOperation == TRUE)
		{
			bCancelOperation = FALSE;
			break;
		}
	}

	XFormEnd:

	FlashMyIcon(FALSE);

	Crc32Table(DELETE_TABLE);

	if (bAviClipOK)
	{
		Animate_Close(hAviClip);
	}
	if (hDialogModeLess)
	{
		DestroyWindow(hDialogModeLess);
	}
	if (hXFormFile)
	{
		CloseMyHandle((LPTSTR)&szXFormFile,hXFormFile);
	}
	// See if we want to wipe this file.
	//..................................
	if (bWipeAfterXform && !bDiskError)
	{
		ConfirmWipeMyFile(IDS_CONFIRMXFORM,(LPBYTE)&szXFormFile,TRUE);
	}
	if (hOutPutFile)
	{
		CloseMyHandle((LPTSTR)&szDestination,hOutPutFile);
		hOutPutFile = 0;

		// If we had an error bail out and delete the last
		// output file. It may be corrupt.
		//................................................
		if (bDiskError)
		{
			DeleteMyFile((LPTSTR)&szDestination);
		}
	}
	if (lpInBuffer)
	{
		ZeroMemory(lpInBuffer,BUFFER_SIZE_IN);
		DeallocateMemory(lpInBuffer);
	}
	if (lpOutBuffer)
	{
		ZeroMemory(lpOutBuffer,BUFFER_SIZE_OUT);
		DeallocateMemory(lpOutBuffer);
	}
	ChangeHelpTopic(dwOldHelpTopic);
	bCancelOperation = FALSE;
	bProcessInProgress = FALSE;
}

// Special hook for open file dialog for encrypting a file.
// Adds a wipe after encryption checkbox.
//.........................................................
UINT CALLBACK MyXformOFNHookProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
	static HWND		hWndParent;
	UINT			uCheck;
	LPHELPINFO		lphi;

	switch (uiMsg)
	{
		case WM_INITDIALOG:
		{
			hWndParent = GetParent(hDlg);
			SetMyIcon(hWndParent);
			CenterWindow(hWndParent,hMainWindow);
			return(TRUE);
		}

		case WM_COMMAND:
		{
			switch(LOWORD(wParam))
			{
				case IDC_WIPEAFTERXFORM:
				{
					uCheck = IsDlgButtonChecked(hDlg,IDC_WIPEAFTERXFORM);
					if (uCheck == BST_CHECKED)
					{
						uCheck = BST_UNCHECKED;
						bWipeAfterXform = FALSE;
					}
					else
					{
						uCheck = BST_CHECKED;
						bWipeAfterXform = TRUE;
					}
					CheckDlgButton(hDlg,IDC_WIPEAFTERXFORM,uCheck);
				}
				break;
			}
		}
		break;

		case WM_HELP:
		{
			lphi = (LPHELPINFO)lParam;
			if (lphi->iContextType == HELPINFO_WINDOW)
			{
				if (lphi->iCtrlId == IDC_WIPEAFTERXFORM)
				{
					PopupHelp(hDlg,lParam);
					return(TRUE);
				}
			}
		}
		break;

		case WM_CONTEXTMENU:
		{
			WhatsThis(hDlg,(HWND)wParam,lParam);
		}
		break;
	}
	return(FALSE);
}

// Extract a transformed file.
//............................
VOID ExtractEmail()
{
	ULARGE_INTEGER	uliFreeCallerBytes;
	ULARGE_INTEGER	uliTotalBytes;
	ULARGE_INTEGER	uliFileSize;
	LARGE_INTEGER	liFilePointer;
	BOOL			bResult;
	OPENFILENAME	ofn;
	HRESULT			hr = ERROR_SUCCESS;
	LPBYTE			lpExtractBuffer = 0;
	DWORD			dwOldHelpTopic;
	LPBYTE			lpDestinationFileName;
	DWORD			dwMessagesExtracted;
	DWORD			dwBytesRead;
	DWORD			dwBytesWritten;
	HANDLE			hXFormFile = 0;
	TCHAR			szOutBuffer[32];
	TCHAR			szRoot[16];
	BROWSEINFO		bi;
	BOOL			bDiskError = TRUE;
    LPITEMIDLIST	lpidl;
    LPMALLOC		lpMalloc;

	bProcessInProgress = TRUE;
	dwOldHelpTopic = ChangeHelpTopic(IDH_EXTRACT);
	bWipeAfterExtr = FALSE;

	// Initialize the OPENFILENAME structure.
	//.......................................
	InitializeOFN(&ofn,SAVE_SOURCE);

	// Initialize with specific information for this procedure.
	//.........................................................
	ofn.lpstrFile = szXFormFile;
	ofn.nMaxFile = sizeof(szXFormFile);
	ofn.hwndOwner = hMainWindow;
	ofn.hInstance = hInst;
	ofn.lpstrFilter = TEXT("All Files [*.*]\0*.*\0E-Mail Files [.eml]\0*.eml\0");
	ofn.nFilterIndex = 1;
	ofn.lpstrTitle = TEXT("Select a File to Extract Transformed E-Mail Files From");
	ofn.Flags = (OFN_EXPLORER | OFN_FILEMUSTEXIST | OFN_PATHMUSTEXIST |
		         OFN_ENABLEHOOK | OFN_ENABLESIZING | OFN_HIDEREADONLY |
				 OFN_SHOWHELP | OFN_ENABLETEMPLATE);
	ofn.lpstrDefExt = NULL;
	if (bWin2000OrGreater)
	{
		ofn.lpTemplateName = TEXT("WIPEAFTEREXTRACTNEW");
	}
	else
	{
		ofn.lpTemplateName = TEXT("WIPEAFTEREXTRACT");
	}
	ofn.lpfnHook = MyExtrOFNHookProc;

	// Setup the icon to use in the caption bar.
	//..........................................
	lpIconPointer = lpszAppName;

	// Now select a file to extract transfomed e-mail files from.
	//...........................................................
	ZeroMemory(&szXFormFile,sizeof(szXFormFile));

	if (!GetOpenFileName(&ofn))
	{
		CommDlgBoxErrorProc(IDS_GET_FILES);
		goto ExtractEnd;
	}
	SaveDirName((LPBYTE)&szXFormFile,SAVE_SOURCE,TRUE);

	// Open the file and get its file size.
	//.....................................
	lpFileName = PathFindFileName((LPCTSTR)&szXFormFile);
	lpFileExtension = PathFindExtension((LPCTSTR)&szXFormFile);
	hXFormFile = CreateMyFile((LPTSTR)&szXFormFile,GENERIC_READ,0,NULL,
							   OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
	if (!hXFormFile)
	{
		goto ExtractEnd;
	}
	uliFileSize.QuadPart = GetMyFileSize((LPTSTR)&szXFormFile,hXFormFile);
	if (uliFileSize.QuadPart == -1)
	{
		goto ExtractEnd;
	}
	bResult = CloseMyHandle((LPTSTR)&szXFormFile,hXFormFile);
	if (!bResult)
	{
		goto ExtractEnd;
	}
	hXFormFile = 0;

	EmptyTheMessageQue();

	// Get the destination for the extracted transformed files.
	//.........................................................
	while(TRUE)
	{
		SetCurrentDirectory((LPCTSTR)&szPreviousDestinationDir);
		ZeroMemory(&szDestination,sizeof(szDestination));

		if (SUCCEEDED(SHGetMalloc(&lpMalloc))) 
		{
			ZeroMemory(&bi,sizeof(bi));
			bi.hwndOwner = hMainWindow;
			bi.pszDisplayName = 0;
			bi.lpszTitle = TEXT("Select a Destination for the Extracted Transformed File(s).");
			bi.pidlRoot = 0;
			bi.ulFlags = BIF_RETURNONLYFSDIRS;
			// If we can use the new style of the dialog box, do it.
			//......................................................
			if (bUseNew)
			{
				hr = CoInitialize(NULL);
				if (SUCCEEDED(hr))
				{
					bi.ulFlags |= BIF_NEWDIALOGSTYLE;
				}
			}
			bi.lpfn = BrowseCallbackProc;

			lpidl = SHBrowseForFolder(&bi);

			if (bUseNew && SUCCEEDED(hr))
			{
				CoUninitialize();
			}
			if (lpidl) 
			{
				bResult = SHGetPathFromIDList(lpidl,(LPSTR)&szDestination);
				lpMalloc->lpVtbl->Free(lpMalloc,lpidl);
				lpMalloc->lpVtbl->Release(lpMalloc);
			}
			else
			{
				// We cancelled out.
				//..................
				goto ExtractEnd;
			}
			SaveDirName((LPBYTE)&szDestination,SAVE_DESTINATION,FALSE);

			// See if we have any free disk space. cd rom drives that
			// are not writable will report zero.
			//.......................................................
			ZeroMemory(&szRoot,sizeof(szRoot));
			CopyMemory(&szRoot,&szDestination,3);
			bResult = GetDiskFreeSpaceEx((LPCTSTR)&szRoot,
										(PULARGE_INTEGER)&uliFreeCallerBytes.QuadPart,
										(PULARGE_INTEGER)&uliTotalBytes.QuadPart,NULL);
			if (!bResult)
			{
				ErrorProcedure((LPTSTR)&szDestination,IDS_GETFREEDSKSPACE,MB_OK);
				goto ExtractEnd;
			}
			if (uliFreeCallerBytes.QuadPart == 0)
			{
				SetLastError(IDS_NOSPACE);
				ErrorProcedure((LPTSTR)&szDestination,IDS_GETFREEDSKSPACE,MB_OK);
				continue;
			}
			if (uliFileSize.QuadPart > uliFreeCallerBytes.QuadPart)
			{
				SetLastError(IDS_NOTRANSFORMROOM);
				ErrorProcedure((LPTSTR)&szDestination,IDS_GETFREEDSKSPACE,MB_OK);
				continue;
			}
			// If we got this far with no error, we have a valid
			// destination.
			//..................................................
			break;
		}
		else
		{
			MessageBoxProc(hMainWindow,IDS_SYSTEM_ERROR,IDS_SELECTDIR,
						   MB_ICONHAND | MB_OK,MB_ICONHAND,0);
			goto ExtractEnd;
		}
	}
	// Setup a pointer to where we add the file names to in the
	// destination file specification.
	//.........................................................
	lpDestinationFileName = PathAddBackslash((LPTSTR)&szDestination);
	
	// Allocate the buffer we will use.
	//.................................
	lpExtractBuffer = AllocateMemory(BUFFER_SIZE_IN);
	if (!lpExtractBuffer)
	{
		goto ExtractEnd;
	}
	bCancelOperation = FALSE;
	hDialogModeLess = CreateDialog(hInst,TEXT("EXTRACT"),hMainWindow,(DLGPROC)ExtractProc);
	if (!hDialogModeLess)
	{
		goto ExtractEnd;
	}
	// Setup the our variables.
	//.........................
	dwMessagesExtracted = 0;
	liFilePointer.QuadPart = 0;
	bEndOfRecon = FALSE;
	lpR64TempIn = (LPBYTE)&ExpandedHeader.EXPANDED_INFO;
	lpR64TempOut = (LPBYTE)&FileInfoHeader;

	// Open the file to extract files from.
	//.....................................
	hXFormFile = CreateMyFile((LPTSTR)&szXFormFile,GENERIC_READ,0,
							   NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
	if (!hXFormFile)
	{
		goto ExtractEnd;
	}
	// While there is still more in the file, look for HR64
	// messages to extract.
	//.....................................................
	while(TRUE)
	{
		EmptyTheMessageQue();
		if (bCancelOperation == TRUE)
		{
			goto ExtractEnd;
		}

		liFilePointer.QuadPart = SetMyFilePointer((LPTSTR)&szXFormFile,hXFormFile,
												   liFilePointer.QuadPart,FILE_BEGIN);
		if (liFilePointer.QuadPart == -1)
		{
			goto ExtractEnd;
		}
		// Read from the file.
		//....................
		bResult = ReadMyFile((LPTSTR)&szXFormFile,hXFormFile,lpExtractBuffer,BUFFER_SIZE_IN,
							  &dwBytesRead,NULL);
		if (!bResult)
		{
			goto ExtractEnd;
		}
		// Check for end of file.
		//.......................
		if (dwBytesRead == 0)
		{
			break;
		}
		// Search for a HR64 header id. Returns pointer to start of
		// id in lpSearchEDI.
		//.............................
		bResult = SearchFor((LPBYTE)&szHeaderId,lstrlen(szHeaderId),lpExtractBuffer,
							 dwBytesRead);
		liFilePointer.QuadPart += (lpSearchEDI - lpExtractBuffer);

		// If no match is found, back up the file pointer 50 bytes
		// so there is an overlap in the search for the id.
		//........................................................
		if (!bResult)
		{
			liFilePointer.QuadPart -= 50;

			// If the bytes read is not equal to BUFFER_SIZE_IN
			// we had an end of file on the last read.
			//.................................................
			if (dwBytesRead != BUFFER_SIZE_IN)
			{
				break;
			}
			// We still have more file to search.
			//...................................
			continue;
		}
		// Move the file pointer and read header plus lots of the file.
		//.............................................................
		liFilePointer.QuadPart = SetMyFilePointer((LPTSTR)&szXFormFile,hXFormFile,
												   liFilePointer.QuadPart,FILE_BEGIN);
		if (liFilePointer.QuadPart == -1)
		{
			goto ExtractEnd;
		}
		// Read in the header.
		//....................
		bResult = ReadMyFile((LPTSTR)&szXFormFile,hXFormFile,
							  &ExpandedHeader,sizeof(EXP_R64_HEADER),&dwBytesRead,NULL);
		if (!bResult)
		{
			goto ExtractEnd;
		}
		if (dwBytesRead != sizeof(EXP_R64_HEADER))
		{
			break;
		}
		// Reposition the file pointer.
		//.............................
		liFilePointer.QuadPart = SetMyFilePointer((LPTSTR)&szXFormFile,hXFormFile,
												   liFilePointer.QuadPart,FILE_BEGIN);
		if (liFilePointer.QuadPart == -1)
		{
			goto ExtractEnd;
		}
		bResult = ReadMyFile((LPTSTR)&szXFormFile,hXFormFile,lpExtractBuffer,BUFFER_SIZE_IN,
							  &dwBytesRead,NULL);
		if(!bResult)
		{
			goto ExtractEnd;
		}
		// Extract and reconstruct the header so we can get the
		// correct file name to save the message to.
		//.....................................................
		dwHoldArea = 0;
		iBitsInHoldArea = 0;
		dwStuffR64Index = 0;
		dwTotalBytes = -1;
		ConvertR64ToBinary((LPBYTE)&szXFormFile,hXFormFile,
							sizeof(ExpandedHeader.EXPANDED_INFO),FALSE);

		// Make sure the length of the destination path and file
		// name do not exceed MAX_PATH.
		//......................................................
		dwTotalBytes = (lstrlen((LPCTSTR)&szDestination) + 
					    lstrlen((LPCTSTR)&FileInfoHeader.THIS_FILE) + 1);
		if (dwTotalBytes > MAX_PATH)
		{
			SetLastError(IDS_PATHTOOLONGEXTRACT);
			ErrorProcedure((LPTSTR)&szXFormFile,IDS_CREATE_OPEN,MB_OK);
			goto ExtractEnd;
		}
		// Form the complete specification.
		//.................................
		CopyMemory(lpDestinationFileName,&FileInfoHeader.THIS_FILE,
				   lstrlen((LPCTSTR)&FileInfoHeader.THIS_FILE));

		// Create the file. It one with the same name already exists
		// bail out.
		//..........................................................
		hOutPutFile = CreateMyFile((LPTSTR)&szDestination,GENERIC_READ | GENERIC_WRITE,0,
									NULL,CREATE_NEW,FILE_ATTRIBUTE_NORMAL,NULL);
		if (!hOutPutFile)
		{
			goto ExtractEnd;
		}
		// Display the number and name of the extracted file.
		//...................................................
		dwMessagesExtracted++;
		FormatMyNumber(dwMessagesExtracted,(LPTSTR)&szOutBuffer,sizeof(szOutBuffer));
		SetDlgItemTextFmt(hDialogModeLess,IDC_FILE2,
					     (LPCTSTR)GetDisplayName(&shfi1,(LPCTSTR)&szDestination));
		SetDlgItemText(hDialogModeLess,IDC_NUMBERLEFT,(LPCTSTR)&szOutBuffer);

		// Now determine the length of the message fragment in memory.
		// Search for the file end signature and then calculate the
		// length of the message fragment to write.
		//...........................................................
		while(TRUE)
		{
			EmptyTheMessageQue();
			if (bCancelOperation == TRUE)
			{
				goto ExtractEnd;
			}

			bResult = SearchFor((LPBYTE)&szEndId[2],9,lpExtractBuffer,dwBytesRead);

			// If no match is found write the whole buffer to disk.
			//.....................................................
			if (!bResult)
			{
				bResult = WriteMyFile((LPTSTR)&szDestination,hOutPutFile,
									   lpExtractBuffer,dwBytesRead,&dwBytesWritten,NULL);
				if (!bResult)
				{
					goto ExtractEnd;
				}
				// Make sure the e-mail file pointer stays accurate.
				//..................................................
				liFilePointer.QuadPart += dwBytesWritten;

				// Read in more of the file.
				//..........................
				bResult = ReadMyFile((LPTSTR)&szXFormFile,hXFormFile,
									  lpExtractBuffer,BUFFER_SIZE_IN,&dwBytesRead,NULL);
				if (!bResult)
				{
					goto ExtractEnd;
				}
				// See if we reached the end of the file before
				// we found the end signature.
				//.............................................
				if (dwBytesRead == 0)
				{
					SetLastError(IDS_ENDOFFILEBEFOREENDID);
					ErrorProcedure((LPTSTR)&szXFormFile,IDS_READ,MB_OK);
					goto ExtractEnd;
				}
			}
			else
			{
				// We have a match. Calculate the number of bytes to
				// write. Make sure file pointer stays accurate.
				//..................................................
				dwBytesRead = (lpSearchEDI - lpExtractBuffer) + sizeof(szEndId) - 2;
				liFilePointer.QuadPart += dwBytesRead;
				bResult = WriteMyFile((LPSTR)&szDestination,hOutPutFile,
									   lpExtractBuffer,dwBytesRead,&dwBytesWritten,NULL);
				if (!bResult)
				{
					goto ExtractEnd;
				}
				bResult = CloseMyHandle((LPTSTR)&szDestination,hOutPutFile);
				if (!bResult)
				{
					goto ExtractEnd;
				}
				hOutPutFile = 0;
				break;
			}
		}
	}
	if (dwMessagesExtracted == 0)
	{
		SetDlgItemText(hDialogModeLess,IDC_NUMBERLEFT,TEXT("0"));
	}
	// Make sure bCancelOperation is set to FALSE.
	//............................................
	bCancelOperation = FALSE;
	bDiskError = FALSE;

	// Change the cancel button to ok.
	//................................
	SetDlgItemText(hDialogModeLess,IDCANCEL,TEXT("&OK"));

	FlashMyIcon(TRUE);

	// Wait until we close the dialog box to exit.
	//............................................
	while(TRUE)
	{
		CheckForMessages();
		if (bCancelOperation == TRUE)
		{
			bCancelOperation = FALSE;
			break;
		}
	}
		
	ExtractEnd:

	FlashMyIcon(FALSE);

	if (hDialogModeLess)
	{
		DestroyWindow(hDialogModeLess);
	}
	if (hOutPutFile)
	{
		CloseMyHandle((LPTSTR)&szDestination,hOutPutFile);
		hOutPutFile = 0;
	}
	if (lpExtractBuffer)
	{
		ZeroMemory(lpExtractBuffer,BUFFER_SIZE_IN);
		DeallocateMemory(lpExtractBuffer);
	}
	if (hXFormFile)
	{
		CloseMyHandle((LPTSTR)&szXFormFile,hXFormFile);
	}
	// See if we want to wipe this file.
	//..................................
	if (bWipeAfterExtr && !bDiskError)
	{
		ConfirmWipeMyFile(IDS_CONFIRMEXTR,(LPBYTE)&szXFormFile,TRUE);
	}
	bCancelOperation = FALSE;
	ChangeHelpTopic(dwOldHelpTopic);
	bProcessInProgress = FALSE;
}

// Special hook for open file dialog for encrypting a file.
// Adds a wipe after encryption checkbox.
//.........................................................
UINT CALLBACK MyExtrOFNHookProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
	static HWND		hWndParent;
	UINT			uCheck;
	LPHELPINFO		lphi;

	switch (uiMsg)
	{
		case WM_INITDIALOG:
		{
			hWndParent = GetParent(hDlg);
			SetMyIcon(hWndParent);
			CenterWindow(hWndParent,hMainWindow);
			return(TRUE);
		}

		case WM_COMMAND:
		{
			switch(LOWORD(wParam))
			{
				case IDC_WIPEAFTEREXTR:
				{
					uCheck = IsDlgButtonChecked(hDlg,IDC_WIPEAFTEREXTR);
					if (uCheck == BST_CHECKED)
					{
						uCheck = BST_UNCHECKED;
						bWipeAfterExtr = FALSE;
					}
					else
					{
						uCheck = BST_CHECKED;
						bWipeAfterExtr = TRUE;
					}
					CheckDlgButton(hDlg,IDC_WIPEAFTEREXTR,uCheck);
				}
				break;
			}
		}
		break;

		case WM_HELP:
		{
			lphi = (LPHELPINFO)lParam;
			if (lphi->iContextType == HELPINFO_WINDOW)
			{
				if (lphi->iCtrlId == IDC_WIPEAFTEREXTR)
				{
					PopupHelp(hDlg,lParam);
					return(TRUE);
				}
			}
		}
		break;

		case WM_CONTEXTMENU:
		{
			WhatsThis(hDlg,(HWND)wParam,lParam);
		}
		break;
	}
	return(FALSE);
}

// Reconstruct one or more transformed files.
//...........................................
VOID ReconstructEmail()
{
	ULARGE_INTEGER	uliFreeCallerBytes;
	ULARGE_INTEGER	uliTotalBytes;
	OPENFILENAME	ofn;
	DWORD			dwOldHelpTopic;
	DWORD			dwFilesLeft;
	DWORD			dwLastError;
	int				iResult;
	BOOL			bResult;
	HRESULT			hr = ERROR_SUCCESS;
	BOOL			bWeFinished = FALSE;
	HANDLE			hXFormFile = 0;
	LPBYTE			lpInBuffer = 0;
	LPBYTE			lpOutBuffer = 0;
	DWORD			dwBytesRead;
	UINT			uiDriveType;
	TCHAR			szRoot[16];
	TCHAR			szOutBuffer[128];
	BROWSEINFO		bi;
    LPITEMIDLIST	lpidl;
    LPMALLOC		lpMalloc;

	bProcessInProgress = TRUE;
	dwOldHelpTopic = ChangeHelpTopic(IDH_RECONSTRUCT);
	bAviClipOK = FALSE;

	// Initialize the OPENFILENAME structure.
	//.......................................
	InitializeOFN(&ofn,SAVE_SOURCE);

	// Initialize with specific information for this procedure.
	//.........................................................
	ofn.lpstrFile = szXFormFile;
	ofn.nMaxFile = sizeof(szXFormFile);
	ofn.hwndOwner = hMainWindow;
	ofn.lpstrFilter = TEXT("Transformed Files [.r64]\0*.r64\0");
	ofn.nFilterIndex = 1;
	ofn.lpstrTitle = TEXT("Select a Transformed File to Reconstruct");
	ofn.Flags = (OFN_EXPLORER | OFN_FILEMUSTEXIST | OFN_PATHMUSTEXIST |
		         OFN_ENABLEHOOK | OFN_ENABLESIZING | OFN_HIDEREADONLY |
				 OFN_SHOWHELP);
	ofn.lpstrDefExt = NULL;
	ofn.lpfnHook = MyOFNHookProc;

	// Setup the icon to use in the caption bar.
	//..........................................
	lpIconPointer = lpszAppName;
	iStepIncrement = 1;

	if (lpMyCmdLine)
	{
		lpMyCmdLine = 0;
		goto SkipFileName;
	}
	// Now select a transformed file to reconstruct.
	//..............................................
	while(TRUE)
	{
		ZeroMemory(&szXFormFile,sizeof(szXFormFile));

		if (!GetOpenFileName(&ofn))
		{
			CommDlgBoxErrorProc(IDS_GET_FILES);
			goto ReconEnd;
		}

		SkipFileName:

		SaveDirName((LPBYTE)&szXFormFile,SAVE_SOURCE,TRUE);

		// Open the file to get the header information and
		// output file name.
		//................................................
		lpFileName = PathFindFileName((LPCTSTR)&szXFormFile);
		lpFileExtension = PathFindExtension((LPCTSTR)&szXFormFile);
		hXFormFile = CreateMyFile((LPTSTR)&szXFormFile,GENERIC_READ,0,NULL,
								  OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
		if (!hXFormFile)
		{
			goto ReconEnd;
		}
		// The header should be right at the beginning of the file.
		//.........................................................
		bResult = ReadMyFile((LPTSTR)&szXFormFile,hXFormFile,
							  &ExpandedHeader,sizeof(EXP_R64_HEADER),&dwBytesRead,NULL);
		if (!bResult)
		{
			goto ReconEnd;
		}
		// Close the file.
		//................
		bResult = CloseMyHandle((LPTSTR)&szXFormFile,hXFormFile);
		if (!bResult)
		{
			goto ReconEnd;
		}
		hXFormFile =0;

		if (dwBytesRead != sizeof(EXP_R64_HEADER))
		{
			SetLastError(IDS_EOFBEFORESTARTHEADER);
			ErrorProcedure((LPTSTR)&szXFormFile,IDS_READ,MB_OK);
			continue;
		}
		// Make sure we have a valid header id.
		//.....................................
		bResult = SearchFor((LPBYTE)&szHeaderId,lstrlen(szHeaderId),
							(LPBYTE)&ExpandedHeader,dwBytesRead);
		if (!bResult)
		{
			SetLastError(IDS_INVALIDEMAILFILE);
			ErrorProcedure((LPTSTR)&szXFormFile,IDS_READ,MB_OK);
			continue;
		}
		// Extract and reconstruct the header so we can get the
		// correct file name to save the reconstructed file to.
		//.....................................................
		dwHoldArea = 0;
		iBitsInHoldArea = 0;
		dwStuffR64Index = 0;
		dwTotalBytes = -1;
		bEndOfRecon = FALSE;
		ZeroMemory(&FileInfoHeader,sizeof(R64_HEADER));
		lpR64TempIn = (LPBYTE)&ExpandedHeader.EXPANDED_INFO;
		lpR64TempOut = (LPBYTE)&FileInfoHeader;
		ConvertR64ToBinary((LPBYTE)&szXFormFile,hXFormFile,
							sizeof(ExpandedHeader.EXPANDED_INFO),FALSE);
		break;
	}
	EmptyTheMessageQue();

	// Select a destination for the reconstructed file.
	//.................................................
	while(TRUE)
	{
		SetCurrentDirectory((LPCTSTR)&szPreviousDestinationDir);
		ZeroMemory(&szDestination,sizeof(szDestination));

		if (SUCCEEDED(SHGetMalloc(&lpMalloc))) 
		{
			ZeroMemory(&bi,sizeof(bi));
			bi.hwndOwner = hMainWindow;
			bi.pszDisplayName = 0;
			bi.lpszTitle = TEXT("Select a Destination for the Reconstructed File.");
			bi.pidlRoot = 0;
			bi.ulFlags = BIF_RETURNONLYFSDIRS;

			// If we can use the new style of the dialog box, do it.
			//......................................................
			if (bUseNew)
			{
				hr = CoInitialize(NULL);
				if (SUCCEEDED(hr))
				{
					bi.ulFlags |= BIF_NEWDIALOGSTYLE;
				}
			}
			bi.lpfn = BrowseCallbackProc;

			lpidl = SHBrowseForFolder(&bi);

			if (bUseNew && SUCCEEDED(hr))
			{
				CoUninitialize();
			}
			if (lpidl) 
			{
				bResult = SHGetPathFromIDList(lpidl,(LPSTR)&szDestination);
				lpMalloc->lpVtbl->Free(lpMalloc,lpidl);
				lpMalloc->lpVtbl->Release(lpMalloc);
			}
			else
			{
				// We cancelled out.
				//..................
				goto ReconEnd;
			}
			SaveDirName((LPBYTE)&szDestination,SAVE_DESTINATION,FALSE);

			// See if we have any free disk space. cd rom drives that
			// are not writable will report zero.
			//.......................................................
			ZeroMemory(&szRoot,sizeof(szRoot));
			CopyMemory(&szRoot,&szDestination,3);
			bResult = GetDiskFreeSpaceEx((LPCTSTR)&szRoot,
										(PULARGE_INTEGER)&uliFreeCallerBytes.QuadPart,
										(PULARGE_INTEGER)&uliTotalBytes.QuadPart,NULL);
			if (!bResult)
			{
				ErrorProcedure((LPTSTR)&szDestination,IDS_GETFREEDSKSPACE,MB_OK);
				goto ReconEnd;
			}
			if (uliFreeCallerBytes.QuadPart == 0)
			{
				SetLastError(IDS_NOSPACE);
				ErrorProcedure((LPTSTR)&szDestination,IDS_GETFREEDSKSPACE,MB_OK);
				continue;
			}
			if (FileInfoHeader.uliFileSize.QuadPart > 
				uliFreeCallerBytes.QuadPart)
			{
				SetLastError(IDS_NORECONSTRUCTROOM);
				ErrorProcedure((LPTSTR)&szDestination,IDS_GETFREEDSKSPACE,MB_OK);
				continue;
			}
			// Get the drive type so we can detemined which avi
			// clip to use.
			//.................................................
			uiDriveType = GetDriveType((LPCTSTR)&szRoot);

			// Make sure the file spec and destination are not too big.
			//.........................................................
			lpDestinationFileName = PathAddBackslash((LPTSTR)&szDestination);
			dwTotalBytes = (lstrlen((LPCTSTR)&szDestination) +
							lstrlen((LPCTSTR)&FileInfoHeader.THIS_FILE) + 1 - 8);
			if (dwTotalBytes > MAX_PATH)
			{
				SetLastError(IDS_PATHTOBIGRECON);
				ErrorProcedure((LPTSTR)&szDestination,IDS_BROWSEFORFOLDER,MB_OK);
				continue;
			}
			// Determine which avi clip to use: file copy, file disk,
			// or file cd rom.
			//.......................................................
			iWhichAviClip = FILE_COPY;
			if (uiDriveType == DRIVE_REMOVABLE && 
			   (*szDestination == 0x41 || *szDestination == 0x61 || 
			    *szDestination == 0x42 || *szDestination == 0x62))
			{
				iWhichAviClip = FILE_DISK;
			}
			else if (uiDriveType == DRIVE_CDROM)
			{
				iWhichAviClip = FILE_CDROM;
			}
			// If we got this far with no error, we have a valid
			// destination.
			//..................................................
			break;
		}
		else
		{
			MessageBoxProc(hMainWindow,IDS_SYSTEM_ERROR,IDS_SELECTDIR,
						   MB_ICONHAND | MB_OK,MB_ICONHAND,0);
			goto ReconEnd;
		}
	}
	// Setup the reconstructed file name. We have to remove two
	// file extensions to get to the original file name.
	//.........................................................
	PathRemoveExtension((LPTSTR)&FileInfoHeader.THIS_FILE);
	PathRemoveExtension((LPTSTR)&FileInfoHeader.THIS_FILE);
	StringCbCatEx((LPTSTR)&szDestination,sizeof(szDestination),
				  (LPCTSTR)&FileInfoHeader.THIS_FILE,NULL,NULL,dwStringSafeFlag);
	lpDestinationExt = PathFindExtension((LPCTSTR)&szDestination);

	// Create the file to hold the reconstructed file. If the file
	// already exists, ask if we want to overwrite.
	//............................................................
	hOutPutFile = CreateFile((LPTSTR)&szDestination,GENERIC_READ | GENERIC_WRITE,0,NULL,
							  CREATE_NEW,FILE_ATTRIBUTE_NORMAL,NULL);

	if (hOutPutFile == INVALID_HANDLE_VALUE)
	{
		hOutPutFile = 0;

		dwLastError = GetLastError();
		if (dwLastError == ERROR_FILE_EXISTS)
		{
			// Ask if we want to override.
			//............................
			iResult = DialogBox(hInst,TEXT("CONFIRMOVERWRITEXFORM"),hMainWindow,
							   (DLGPROC)ConfirmOverWriteXformProc);

			// See if we had a system error in creating the dialog box.
			//.........................................................
			if (iResult == -1)
			{
				ErrorProcedure(lpszNA,IDS_CREATEDIALOGBOX,MB_OK);
				goto ReconEnd;
			}
			// Destroy the icon if we used it.
			//................................
			if (hIcon)
			{
				DestroyIcon(hIcon);
				hIcon = 0;
			}
			// Quit if we canceled.
			//.....................
			if (iResult == IDCANCEL)
			{
				goto ReconEnd;
			}
			// We want to overwrite the file.
			//...............................
			hOutPutFile = CreateMyFile((LPTSTR)&szDestination,GENERIC_READ | GENERIC_WRITE,
									    0,NULL,TRUNCATE_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
			if (!hOutPutFile)
			{
				goto ReconEnd;
			}
		}
		else
		{
			SetLastError(dwLastError);
			ErrorProcedure((LPTSTR)&szDestination,IDS_CREATE_OPEN,MB_OK);
			goto ReconEnd;
		}
	}
	// Setup the name of the first file to read to reconstruct.
	//.........................................................
	CopyMemory(&szR64FileExt,&szR64ExtDup,sizeof(szR64ExtDup));
	PathRemoveFileSpec((LPTSTR)&szXFormFile);
	lpFileName = PathAddBackslash((LPTSTR)&szXFormFile);
	StringCbCatEx((LPTSTR)&szXFormFile,sizeof(szXFormFile),
				  (LPCTSTR)&FileInfoHeader.THIS_FILE,NULL,NULL,dwStringSafeFlag);
	lpFileExtension = lpFileName;
	lpFileExtension += lstrlen(FileInfoHeader.THIS_FILE);
	StringCbCatEx((LPTSTR)&szXFormFile,sizeof(szXFormFile),(LPCTSTR)&szR64FileExt,NULL,NULL,
				   dwStringSafeFlag);

	// Setup the total number of files to process.
	//............................................
	dwFilesLeft = FileInfoHeader.TOTAL_FILES;

	dwCrcOk = 0;
	dwCrcBad = 0;

	// Allocate memory for our two buffers.
	//.....................................
	lpInBuffer = AllocateMemory(BUFFER_SIZE_IN);
	lpOutBuffer = AllocateMemory(BUFFER_SIZE_OUT);
	if (!lpInBuffer || !lpOutBuffer)
	{
		goto ReconEnd;
	}
	// Build the crc32 table.
	//.......................
	bResult = Crc32Table(BUILD_TABLE);
	if (!bResult)
	{
		goto ReconEnd;
	}
	// Setup our modeless dialog box.
	//...............................
	bCancelOperation = FALSE;
	hDialogModeLess = CreateDialog(hInst,TEXT("RECONSTRUCT"),hMainWindow,
								  (DLGPROC)ReconstructProc);
	if (!hDialogModeLess)
	{
		ErrorProcedure(lpszNA,IDS_CREATEDIALOGBOX,MB_OK);
		goto ReconEnd;;
	}
	// Start the avi clip.
	//....................
	if (bAviClipOK)
	{
		bAviClipOK = Animate_Play(hAviClip,0,-1,-1);
	}
	// Process the files in a loop.
	//.............................
	while(dwFilesLeft != 0)
	{
		EmptyTheMessageQue();
		if (bCancelOperation == TRUE)
		{
			goto ReconEnd;
		}
		// Open the file and extract the header.
		//......................................
		hXFormFile = CreateMyFile((LPTSTR)&szXFormFile,GENERIC_READ,0,NULL,
								   OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
		if (!hXFormFile)
		{
			goto ReconEnd;
		}
		// The header should be right at the beginning of the file.
		//.........................................................
		bResult = ReadMyFile((LPTSTR)&szXFormFile,hXFormFile,
							 &ExpandedHeader,sizeof(EXP_R64_HEADER),&dwBytesRead,NULL);
		if (!bResult)
		{
			goto ReconEnd;
		}
		if (dwBytesRead != sizeof(EXP_R64_HEADER))
		{
			SetLastError(IDS_EOFBEFORESTARTHEADER);
			ErrorProcedure((LPTSTR)&szXFormFile,IDS_READ,MB_OK);
			goto ReconEnd;
		}
		// Make sure we have a valid header id.
		//.....................................
		bResult = SearchFor((LPBYTE)&szHeaderId,lstrlen(szHeaderId),
							(LPBYTE)&ExpandedHeader,dwBytesRead);
		if (!bResult)
		{
			SetLastError(IDS_INVALIDEMAILFILE);
			ErrorProcedure((LPTSTR)&szXFormFile,IDS_READ,MB_OK);
			goto ReconEnd;
		}
		// Extract and reconstruct the header so we can get the
		// correct file name to save the reconstructed file to.
		//.....................................................
		dwHoldArea = 0;
		iBitsInHoldArea = 0;
		dwStuffR64Index = 0;
		dwTotalBytes = -1;
		bEndOfRecon = FALSE;
		lpR64TempIn = (LPBYTE)&ExpandedHeader.EXPANDED_INFO;
		lpR64TempOut = (LPBYTE)&FileInfoHeader;
		ConvertR64ToBinary((LPBYTE)&szXFormFile,hXFormFile,
							sizeof(ExpandedHeader.EXPANDED_INFO),FALSE);
	
		EmptyTheMessageQue();
		if (bCancelOperation == TRUE)
		{
			goto ReconEnd;
		}
		// Setup the initial variables for reconstructing the
		// rest of the file.
		//...................................................
		dwHoldArea = 0;
		iBitsInHoldArea = 0;
		dwStuffR64Index = 0;
		dwCheckCrc = -1;
		lpR64TempIn = lpInBuffer;
		lpR64TempOut = lpOutBuffer;

		// Figure out the total number of bytes to process in the
		// reconstruction from information in the header.
		//.......................................................
		dwTotalBytes = ((FileInfoHeader.NUMBER_64_BLOCKS * 64) + 
						 FileInfoHeader.LAST_BLOCK_SIZE);

		// Process the file.
		//..................
		while(TRUE)
		{
			bResult = ReadMyFile((LPTSTR)&szXFormFile,hXFormFile,
								 lpInBuffer,BUFFER_SIZE_IN,&dwBytesRead,NULL);
			if (!bResult)
			{
				goto ReconEnd;
			}
			// If the end of the file reached before reconstruction
			// is complete, we have possible file corruption.
			//.....................................................
			if (dwBytesRead == 0 && !bEndOfRecon)
			{
				SetLastError(IDS_EOFBEFOREENDOFRECON);
				ErrorProcedure((LPTSTR)&szDestination,IDS_READ,MB_OK);
				goto ReconEnd;
			}
			// Convert what we read.
			//......................
			bResult = ConvertR64ToBinary((LPBYTE)&szDestination,hOutPutFile,dwBytesRead,TRUE);
			if (!bResult)
			{
				goto ReconEnd;
			}
			if (bEndOfRecon)
			{
				break;
			}
			if (bCancelOperation == TRUE)
			{
				goto ReconEnd;
			}
		}
		// Empty the output buffer.
		//.........................
		bResult = UnStuffR64((LPBYTE)&szDestination,hOutPutFile,0,CLOSE,FALSE);
		if (!bResult)
		{
			goto ReconEnd;
		}
		// Close the input file.
		//......................
		bResult = CloseMyHandle((LPTSTR)&szXFormFile,hXFormFile);
		if (!bResult)
		{
			goto ReconEnd;
		}
		hXFormFile = 0;

		// Set the name of the file to reconstruct from.
		//..............................................
		SetDlgItemTextFmt(hDialogModeLess,IDC_FILE2,
						 (LPCTSTR)GetDisplayName(&shfi1,(LPCTSTR)&szXFormFile));

		// Update the progress bar.
		//.........................
		SendMessage(GetDlgItem(hDialogModeLess,IDC_PROGRESS),PBM_STEPIT,0,0);

		// Check the crc check value to see if it is valid.
		//.................................................
		dwCheckCrc ^= -1;

		if (dwCheckCrc != FileInfoHeader.FILE_CRC)
		{
			dwCrcBad++;
			SetLastError(IDS_RECONCRCFAILED);
			ErrorProcedure((LPTSTR)&szXFormFile,IDS_READ,MB_OK);
		}
		else
		{
			dwCrcOk++;
		}
		// Process the files that are left, if any.
		//.........................................
		if (dwFilesLeft > 1)
		{
			// Setup the next number for the input file.
			//..........................................
			__asm
			{
				mov		edi,offset szR64FileExt
				inc		byte ptr [edi+3]
				cmp		byte ptr [edi+3],0x3a
				jne		L1
				mov		byte ptr [edi+3],'0'
				inc		byte ptr [edi+2]
			L1:	cmp		byte ptr [edi+2],0x3a
				jne		L2
				mov		byte ptr [edi+2],'0'
				inc		byte ptr [edi+1]
			L2:
			}
			CopyMemory(lpFileExtension,&szR64FileExt,lstrlen((LPCTSTR)szR64FileExt));
		}
		dwFilesLeft--;
	}
	// Set the position of the progress bar to 100% if we did not quit
	// or exit with an error
	//................................................................
	if (!bCancelOperation)
	{
		SendMessage(GetDlgItem(hDialogModeLess,IDC_PROGRESS),PBM_SETPOS,
							  (WPARAM)FileInfoHeader.TOTAL_FILES,0);
	}
	// Set the files attributes and correct times.
	//............................................
	bResult = SetFileTime(hOutPutFile,&FileInfoHeader.CREATION,&FileInfoHeader.ACCESSED,
						  &FileInfoHeader.WRITTEN);
	if (!bResult)
	{
		ErrorProcedure((LPTSTR)&szDestination,IDS_SETFILETIME,MB_OK);
	}
	// Close the reconstructed file.
	//..............................
	bResult = CloseMyHandle((LPTSTR)&szDestination,hOutPutFile);
	if (!bResult)
	{
		goto ReconEnd;
	}
	hOutPutFile = 0;

	// Set the file attributes.
	//.........................
	SetMyFileAttributes((LPBYTE)&szDestination,FileInfoHeader.ATTRIBUTES);

	// We finished the file reconstruction.
	//.....................................
	bWeFinished = TRUE;

	// Display the number of files that passed their integrity checks.
	//................................................................
	StringCbPrintf((LPTSTR)&szOutBuffer,sizeof(szOutBuffer),(LPCTSTR)&szStatusFormat,
					dwCrcOk,FileInfoHeader.TOTAL_FILES);
	SetDlgItemText(hDialogModeLess,IDC_STATEMENT1,(LPCTSTR)&szOutBuffer);

	// Make sure bCancelOperation is set to FALSE.
	//............................................
	bCancelOperation = FALSE;

	// Stop the avi clip.
	//...................
	if (bAviClipOK)
	{
		bAviClipOK = Animate_Stop(hAviClip);
	}
	// Change the cancel button to ok.
	//................................
	SetDlgItemText(hDialogModeLess,IDCANCEL,TEXT("&OK"));

	FlashMyIcon(TRUE);

	// Wait until we close the dialog box to exit.
	//............................................
	while(TRUE)
	{
		CheckForMessages();
		if (bCancelOperation == TRUE)
		{
			break;
		}
	}

	ReconEnd:

	FlashMyIcon(FALSE);

	if (bAviClipOK)
	{
		Animate_Close(hAviClip);
	}
	if (hDialogModeLess)
	{
		DestroyWindow(hDialogModeLess);
	}
	Crc32Table(DELETE_TABLE);

	if (lpInBuffer)
	{
		ZeroMemory(lpInBuffer,BUFFER_SIZE_IN);
		DeallocateMemory(lpInBuffer);
	}
	if (lpOutBuffer)
	{
		ZeroMemory(lpOutBuffer,BUFFER_SIZE_OUT);
		DeallocateMemory(lpOutBuffer);
	}
	if (hXFormFile)
	{
		CloseMyHandle((LPTSTR)&szXFormFile,hXFormFile);
	}
	if (hOutPutFile)
	{
		CloseMyHandle((LPTSTR)&szDestination,hOutPutFile);
		hOutPutFile = 0;
		
		// If we did not finish the file, delete it.
		//..........................................
		if (!bWeFinished)
		{
			DeleteMyFile((LPTSTR)&szDestination);
		}
	}
	bCancelOperation = FALSE;
	bProcessInProgress = FALSE;
	ChangeHelpTopic(dwOldHelpTopic);
}

// CALLBACK procedure for asking confirmation on overwriting
// the file with the one we are about to transform.
//........................................................
LRESULT CALLBACK ConfirmOverWriteXformProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
	switch(uiMsg)
	{
		case WM_INITDIALOG:
		{
			LARGE_INTEGER		li;
			WIN32_FIND_DATA		FindData;
			TCHAR				szInBuffer[332];
			TCHAR				szFormatedNumber[64];
			HANDLE				hSearchHandle;
			FILETIME			ftLocalTime;
			SYSTEMTIME			stLocalTime;
			TCHAR				szLocalDate[128];
			TCHAR				szLocalTime[64];

			// Clear a few variables.
			//.......................
			ZeroMemory(&szFormatedNumber,sizeof(szFormatedNumber));
			ZeroMemory(&szLocalDate,sizeof(szLocalDate));
			ZeroMemory(&szLocalTime,sizeof(szLocalTime));
			ZeroMemory(&szInBuffer,sizeof(szInBuffer));

			// Setup the icon to use in the caption bar.
			//..........................................
			lpIconPointer = lpszAppName;
			SetMyIcon(hDlg);

			// Setup the dialog box.
			//......................
			SetDlgItemTextFmt(hDlg,IDC_CONTAINS,
							 (LPCTSTR)GetDisplayName(&shfi1,(LPCTSTR)&szDestination));

			// Let find the icon for the file.
			//................................
			hIcon = FindMyIcon((LPBYTE)&szDestination,lpDestinationExt);

			// If we did not find one, use the default.
			//.........................................
			if (!hIcon)
			{
				hIcon = LoadImage(hInst,"I_FACEFROWN",IMAGE_ICON,32,32,LR_SHARED);
			}
			if (hIcon)
			{
				SendMessage(GetDlgItem(hDlg,IDC_ICON1),STM_SETICON,(WPARAM)hIcon,0);
				SendMessage(GetDlgItem(hDlg,IDC_ICON2),STM_SETICON,(WPARAM)hIcon,0);
			}
			ZeroMemory(&szInBuffer,sizeof(szInBuffer));

			// Setup the file information for each file.
			// Do the destination file first.
			//..........................................
			hSearchHandle = FindFirstFile((LPCTSTR)&szDestination,&FindData);
			FindClose(hSearchHandle);
			li.LowPart = FindData.nFileSizeLow;
			li.HighPart = FindData.nFileSizeHigh;
			_i64toa(li.QuadPart,(LPBYTE)&szInBuffer,10);
			GetNumberFormat(LOCALE_USER_DEFAULT,0,(LPCTSTR)&szInBuffer,
				            &nFormatInfo,(LPTSTR)&szFormatedNumber,
							sizeof(szFormatedNumber));
			StringCbPrintf(szInBuffer,sizeof(szInBuffer),lpszSizeFormat,szFormatedNumber);
			SetDlgItemText(hDlg,IDC_SIZE1,(LPCTSTR)szInBuffer);
			ZeroMemory(&szInBuffer,sizeof(szInBuffer));

			// Now do the time and date.
			//..........................
			FileTimeToLocalFileTime((LPFILETIME)&FindData.ftLastWriteTime,
								   (LPFILETIME)&ftLocalTime);
			FileTimeToSystemTime((LPFILETIME)&ftLocalTime,(LPSYSTEMTIME)&stLocalTime);
			// Format the date.
			//.................
			GetDateFormat(LOCALE_USER_DEFAULT,DATE_LONGDATE,&stLocalTime,
				          NULL,(LPTSTR)&szLocalDate,sizeof(szLocalDate));

			// Format the time.
			//.................
			GetTimeFormat(LOCALE_USER_DEFAULT,TIME_FORCE24HOURFORMAT,
						  &stLocalTime,NULL,(LPTSTR)&szLocalTime,sizeof(szLocalTime));
			StringCbPrintf(szInBuffer,sizeof(szInBuffer),lpszDateTimeFormat,&szLocalDate,
						   &szLocalTime);
			SetDlgItemText(hDlg,IDC_DATETIME1,(LPCTSTR)szInBuffer);

			// Clear a few variables.
			//.......................
			ZeroMemory(&szFormatedNumber,sizeof(szFormatedNumber));
			ZeroMemory(&szLocalDate,sizeof(szLocalDate));
			ZeroMemory(&szLocalTime,sizeof(szLocalTime));
			ZeroMemory(&szInBuffer,sizeof(szInBuffer));

			// Setup the information for the source file.
			//...........................................
			_ui64toa(FileInfoHeader.uliFileSize.QuadPart,(LPBYTE)&szInBuffer,10);
			GetNumberFormat(LOCALE_USER_DEFAULT,0,(LPCTSTR)&szInBuffer,
				            &nFormatInfo,(LPTSTR)&szFormatedNumber,sizeof(szFormatedNumber));
			StringCbPrintf(szInBuffer,sizeof(szInBuffer),lpszSizeFormat,szFormatedNumber);
			SetDlgItemText(hDlg,IDC_SIZE2,(LPCTSTR)szInBuffer);
			ZeroMemory(&szInBuffer,sizeof(szInBuffer));

			// Now do the time and date.
			//..........................
			FileTimeToLocalFileTime((LPFILETIME)&FileInfoHeader.WRITTEN,
								    (LPFILETIME)&ftLocalTime);
			FileTimeToSystemTime((LPFILETIME)&ftLocalTime,(LPSYSTEMTIME)&stLocalTime);
			// Format the date.
			//.................
			GetDateFormat(LOCALE_USER_DEFAULT,DATE_LONGDATE,&stLocalTime,
				          NULL,(LPTSTR)&szLocalDate,sizeof(szLocalDate));

			// Format the time.
			//.................
			GetTimeFormat(LOCALE_USER_DEFAULT,TIME_FORCE24HOURFORMAT,
						  &stLocalTime,NULL,(LPTSTR)&szLocalTime,sizeof(szLocalTime));
			StringCbPrintf(szInBuffer,sizeof(szInBuffer),lpszDateTimeFormat,&szLocalDate,
						   &szLocalTime);
			SetDlgItemText(hDlg,IDC_DATETIME2,(LPCTSTR)szInBuffer);

			// Center the window.
			//...................
			CenterWindow(hDlg,GetWindow(hDlg,GW_OWNER));
			return(TRUE);
		}

		case WM_COMMAND:
		{
			switch (LOWORD(wParam))
			{
				case IDC_MYYESXFORM:
				{
					EndDialog(hDlg,IDC_MYYESXFORM);
				}
				break;

				case IDCANCEL:
				{
					EndDialog(hDlg,IDCANCEL);
				}
				break;

				case IDC_MYHELP:
				{
					DisplayMyHelp(hDlg);
				}
				break;
			}
			break;
		}

		case WM_HELP:
		{
			PopupHelp(hDlg,lParam);
		}
		break;

		case WM_CONTEXTMENU:
		{
			WhatsThis(hDlg,(HWND)wParam,lParam);
		}
		break;
	
		default:
			return(FALSE);
	}
	return(TRUE);
}

// CALLBACK procedure for setting the size of the files
// we will be breaking the original file into.
//.....................................................
LRESULT CALLBACK TransformSizeProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
	switch(uiMsg)
	{
		case WM_INITDIALOG:
		{
			int			iControl;
			int			i;
			DWORD		dwResult;
			DWORD		dwDivisor;
			TCHAR		szInBuffer[128];
			TCHAR		szFormatedNumber[64];

			// Setup the icon to use in the caption bar.
			//..........................................
			lpIconPointer = lpszAppName;
			SetMyIcon(hDlg);

			// Let find the icon for the file.
			//................................
			hIcon = FindMyIcon((LPBYTE)&szXFormFile,lpFileExtension);

			// If we did not find one, use the default.
			//.........................................
			if (!hIcon)
			{
				hIcon = LoadImage(hInst,"I_FACEFROWN",IMAGE_ICON,32,32,LR_SHARED);
			}
			if (hIcon)
			{
				SendMessage(GetDlgItem(hDlg,IDC_ICON1),STM_SETICON,(WPARAM)hIcon,0);
			}
			// Setup the name of the file to transform.
			//.........................................
			SetDlgItemTextFmt(hDlg,IDC_CONTAINS,
						     (LPCTSTR)GetDisplayName(&shfi1,(LPCTSTR)&szXFormFile));

			// Setup the size of the file.
			//............................
			_i64toa(FileInfoHeader.uliFileSize.QuadPart,(LPBYTE)&szInBuffer,10);
			GetNumberFormat(LOCALE_USER_DEFAULT,0,(LPCTSTR)&szInBuffer,
				            &nFormatInfo,(LPTSTR)&szFormatedNumber,sizeof(szFormatedNumber));
			StringCbPrintf(szInBuffer,sizeof(szInBuffer),lpszSizeFormat,szFormatedNumber);
			SetDlgItemText(hDlg,IDC_SIZE1,(LPCTSTR)szInBuffer);

			// Setup the size radiobuttons. First determine which
			// radiobuttons should be grayed. Start with the 
			// original size button.
			//...................................................
			if (FileInfoHeader.uliFileSize.QuadPart > 46080)
			{
				EnableWindow(GetDlgItem(hDlg,IDC_TRANSFORM1),FALSE);
			}
			iControl = IDC_TRANSFORM2;

			for (i = 1; i < 7; i++)
			{
				dwDivisor = DivideTable[i];

				if (FileInfoHeader.uliFileSize.QuadPart < dwDivisor)
				{
					EnableWindow(GetDlgItem(hDlg,iControl),FALSE);
					iControl++;
					continue;
				}

				__asm
				{
					mov		edx,FileInfoHeader.uliFileSize.HighPart
					mov		eax,FileInfoHeader.uliFileSize.LowPart
					mov		ecx,dwDivisor
					div		ecx
					mov		dwResult,eax
				}
				if (dwResult > MAX_FILES)
				{
					EnableWindow(GetDlgItem(hDlg,iControl),FALSE);
				}
				iControl++;
			}
			// Center the window.
			//...................
			CenterWindow(hDlg,GetWindow(hDlg,GW_OWNER));
			return(TRUE);
		}

		case WM_COMMAND:
		{
			switch (LOWORD(wParam))
			{
				case IDC_TRANSFORM1:
				{
					CheckRadioButton(hDlg,IDC_TRANSFORM1,IDC_TRANSFORM7,IDC_TRANSFORM1);
					dwSizeSelect = BUFFER_SIZE_IN;
				}
				break;

				case IDC_TRANSFORM2:
				{
					CheckRadioButton(hDlg,IDC_TRANSFORM1,IDC_TRANSFORM7,IDC_TRANSFORM2);
					dwSizeSelect = 7680;
				}
				break;

				case IDC_TRANSFORM3:
				{
					CheckRadioButton(hDlg,IDC_TRANSFORM1,IDC_TRANSFORM7,IDC_TRANSFORM3);
					dwSizeSelect = 15360;
				}
				break;

				case IDC_TRANSFORM4:
				{
					CheckRadioButton(hDlg,IDC_TRANSFORM1,IDC_TRANSFORM7,IDC_TRANSFORM4);
					dwSizeSelect = 23040;
				}
				break;

				case IDC_TRANSFORM5:
				{
					CheckRadioButton(hDlg,IDC_TRANSFORM1,IDC_TRANSFORM7,IDC_TRANSFORM5);
					dwSizeSelect = 30720;
				}
				break;

				case IDC_TRANSFORM6:
				{
					CheckRadioButton(hDlg,IDC_TRANSFORM1,IDC_TRANSFORM7,IDC_TRANSFORM6);
					dwSizeSelect = 38400;
				}
				break;

				case IDC_TRANSFORM7:
				{
					CheckRadioButton(hDlg,IDC_TRANSFORM1,IDC_TRANSFORM7,IDC_TRANSFORM7);
					dwSizeSelect = 46080;
				}
				break;

				case IDOK:
				{
					EndDialog(hDlg,IDOK);
				}
				break;

				case IDCANCEL:
				{
					EndDialog(hDlg,IDCANCEL);
				}
				break;

				case IDC_MYHELP:
				{
					DisplayMyHelp(hDlg);
				}
				break;
			}
			break;
		}

		case WM_HELP:
		{
			PopupHelp(hDlg,lParam);
		}
		break;

		case WM_CONTEXTMENU:
		{
			WhatsThis(hDlg,(HWND)wParam,lParam);
		}
		break;

		default:
			return(FALSE);
	}
	return(TRUE);
}

// CALLBACK procedure for creating the transfomed files for
// e-mail transmission.
//.........................................................
LRESULT CALLBACK TransformProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
	switch(uiMsg)
	{
		case WM_INITDIALOG:
		{
			// Setup the icon to use in the caption bar.
			//..........................................
			lpIconPointer = lpszAppName;
			SetMyIcon(hDlg);

			// Open the avi clip and display its first frame
			// in the animation control.
			//..............................................
			hAviClip = GetDlgItem(hDlg,IDC_ANIMATE);
			bAviClipOK = Animate_Open(hAviClip,(LPSTR)iWhichAviClip);

			// Setup the icon and file name of the file we will
			// transform.
			//.................................................
			SetDlgItemTextFmt(hDlg,IDC_FILE1,
							 (LPCTSTR)GetDisplayName(&shfi1,(LPCTSTR)&szXFormFile));

			// Let find the icon for the file.
			//................................
			hIcon = FindMyIcon((LPBYTE)&szXFormFile,lpFileExtension);

			// If we did not find one, use the default.
			//.........................................
			if (!hIcon)
			{
				hIcon = LoadImage(hInst,"I_FACEFROWN",IMAGE_ICON,32,32,LR_SHARED);
			}
			if (hIcon)
			{
				SendMessage(GetDlgItem(hDlg,IDC_ICON1),STM_SETICON,(WPARAM)hIcon,0);
			}
			// Setup the range and step increment for the progress bar.
			//.........................................................
			SendMessage(GetDlgItem(hDlg,IDC_PROGRESS),PBM_SETRANGE32,0,
					   (LPARAM)FileInfoHeader.TOTAL_FILES);
			SendMessage(GetDlgItem(hDlg,IDC_PROGRESS),PBM_SETSTEP,(WPARAM)iStepIncrement,0);

			CenterWindow(hDlg,GetWindow(hDlg,GW_OWNER));
			SetFocus(GetDlgItem(hDlg,IDCANCEL));
			return(FALSE);
		}

		case WM_ACTIVATE:
		{
			if (wParam == 0)
			{
				hDlgCurrent = NULL;
			}
			else
			{
				hDlgCurrent = hDlg;
			}
			return(FALSE);
		}

		case WM_COMMAND:
		{
			switch (LOWORD(wParam))
			{
				// Inform the procedure that we want to quit.
				//...........................................
				case IDCANCEL:
				{
					bCancelOperation = TRUE;
				}
				break;
			}
		}
		break;

		case WM_DESTROY:
		{
			hDialogModeLess = NULL;
		}
		break;

		default:
			return(FALSE);
	}
	return(TRUE);
}

// CALLBACK procedure for extracting transformed files from
// an e-mail file.
//.........................................................
LRESULT CALLBACK ExtractProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
	switch(uiMsg)
	{
		case WM_INITDIALOG:
		{
			// Setup the icon to use in the caption bar.
			//..........................................
			lpIconPointer = lpszAppName;
			SetMyIcon(hDlg);
			SetBoldFont(hDlg,IDC_NUMBERLEFT,IDC_FILE_DATA1);

			// Setup the icon and file name of the file we will
			// extract from.
			//.................................................
			SetDlgItemTextFmt(hDlg,IDC_FILE1,
							 (LPCTSTR)GetDisplayName(&shfi1,(LPCTSTR)&szXFormFile));

			// Let find the icon for the file.
			//................................
			hIcon = FindMyIcon((LPBYTE)&szXFormFile,lpFileExtension);

			// If we did not find one, use the default.
			//.........................................
			if (!hIcon)
			{
				hIcon = LoadImage(hInst,"I_FACEFROWN",IMAGE_ICON,32,32,LR_SHARED);
			}
			if (hIcon)
			{
				SendMessage(GetDlgItem(hDlg,IDC_ICON1),STM_SETICON,(WPARAM)hIcon,0);
			}
			CenterWindow(hDlg,GetWindow(hDlg,GW_OWNER));
			SetFocus(GetDlgItem(hDlg,IDCANCEL));
			return(FALSE);
		}

		case WM_ACTIVATE:
		{
			if (wParam == 0)
			{
				hDlgCurrent = NULL;
			}
			else
			{
				hDlgCurrent = hDlg;
			}
			return(FALSE);
		}

		case WM_COMMAND:
		{
			switch (LOWORD(wParam))
			{
				// Inform the procedure that we want to quit.
				//...........................................
				case IDCANCEL:
				{
					bCancelOperation = TRUE;
				}
				break;
			}
		}
		break;

		case WM_DESTROY:
		{
			if (hDlgFont)
			{
				DeleteObject(hDlgFont);
				hDlgFont = 0;
			}
			hDialogModeLess = NULL;
		}
		break;

		default:
			return(FALSE);
	}
	return(TRUE);
}

// CALLBACK procedure for reconstructing the original file from
// one or more transformed files.
//.............................................................
LRESULT CALLBACK ReconstructProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
	switch(uiMsg)
	{
		case WM_INITDIALOG:
		{
			// Setup the icon to use in the caption bar.
			//..........................................
			lpIconPointer = lpszAppName;
			SetMyIcon(hDlg);
			SetBoldFont2(hDlg,IDC_STATEMENT1);

			// Open the avi clip and display its first frame
			// in the animation control.
			//..............................................
			hAviClip = GetDlgItem(hDlg,IDC_ANIMATE);
			bAviClipOK = Animate_Open(hAviClip,(LPSTR)iWhichAviClip);

			// Setup the icon and file name of the reconstructed file.
			//........................................................
			SetDlgItemTextFmt(hDlg,IDC_FILE1,
							 (LPCTSTR)GetDisplayName(&shfi1,(LPCTSTR)&szDestination));

			// Let find the icon for the file.
			//................................
			hIcon = FindMyIcon((LPBYTE)&szDestination,lpDestinationExt);

			// If we did not find one, use the default.
			//.........................................
			if (!hIcon)
			{
				hIcon = LoadImage(hInst,"I_FACEFROWN",IMAGE_ICON,32,32,LR_SHARED);
			}
			if (hIcon)
			{
				SendMessage(GetDlgItem(hDlg,IDC_ICON1),STM_SETICON,(WPARAM)hIcon,0);
			}
			// Setup the range and step increment for the progress bar.
			//.........................................................
			SendMessage(GetDlgItem(hDlg,IDC_PROGRESS),PBM_SETRANGE32,0,
					   (LPARAM)FileInfoHeader.TOTAL_FILES);
			SendMessage(GetDlgItem(hDlg,IDC_PROGRESS),PBM_SETSTEP,(WPARAM)iStepIncrement,0);

			CenterWindow(hDlg,GetWindow(hDlg,GW_OWNER));
			SetFocus(GetDlgItem(hDlg,IDCANCEL));
			return(FALSE);
		}

		case WM_ACTIVATE:
		{
			if (wParam == 0)
			{
				hDlgCurrent = NULL;
			}
			else
			{
				hDlgCurrent = hDlg;
			}
			return(FALSE);
		}

		case WM_COMMAND:
		{
			switch (LOWORD(wParam))
			{
				// Inform the procedure that we want to quit.
				//...........................................
				case IDCANCEL:
				{
					bCancelOperation = TRUE;
				}
				break;
			}
		}
		break;

		case WM_DESTROY:
		{
			if (hDlgFont2)
			{
				DeleteObject(hDlgFont2);
				hDlgFont2 = 0;
			}
			hDialogModeLess = NULL;
		}
		break;

		default:
			return(FALSE);
	}
	return(TRUE);
}

// ConvertToR64 converts three bytes in the in buffer to 4 ascii
// bytes in the out buffer using the radix 64 method. Returns
// FALSE if i/o error.
//..............................................................
BOOL ConvertToR64(LPBYTE lpFileName, HANDLE hFile, DWORD dwByteCount, BOOL bCheckIntegrity)
{
	BOOL		bResult = TRUE;
	DWORD		dwNextByte;
	LPBYTE		lpTempPtr;

	lpTempPtr = lpR64TempIn;

	while(dwByteCount != 0)
	{
		EmptyTheMessageQue();
		if (bCancelOperation == TRUE)
		{
			break;
		}
		__asm
		{
			mov		esi,lpTempPtr
			lodsb
			mov		dwNextByte,eax
			inc		lpTempPtr
		}
		bResult = StuffR64(lpFileName,hFile,dwNextByte,NORMAL,bCheckIntegrity);
		if (!bResult)
		{
			break;
		}
		dwByteCount--;
	}
	return(bResult);
}

// StuffR64 converts 6 bits into a byte according to the
// translation table. Returns FALSE if i/o error.
//......................................................
BOOL StuffR64(LPBYTE lpFileName, HANDLE hFile, DWORD dwNextByte, DWORD dwFlag, 
			  BOOL bDoIntegrity)
{
	DWORD		dwBytesWritten;
	BOOL		bResult = TRUE;

	// If dwFlag is NORMAL put this byte in the hold area, then
	// convert the contents of the hold area 6 bits at a time
	// into bytes iaw the translation table.
	//..........................................................
	if (dwFlag == NORMAL)
	{
		if (bDoIntegrity)
		{
			// Calculate the crc32 check value.
			//.................................
			__asm
			{
				mov		eax,dwNextByte
				mov		ebx,FileInfoHeader.FILE_CRC
				xor		al,bl
				shr		FileInfoHeader.FILE_CRC,8
				movzx	esi,al
				mov		edi,lpCrc32Table
				mov		eax,dword ptr [edi][esi*4]
				xor		FileInfoHeader.FILE_CRC,eax
			}
		}
		// Add the byte to the hold area.
		//...............................
		__asm
		{
			mov		ecx,iBitsInHoldArea
			mov		eax,dwNextByte
			shl		eax,cl
			or		dwHoldArea,eax
			add		iBitsInHoldArea,8
			mov		edi,lpR64TempOut
			add		edi,dwStuffR64Index
			mov		ebx,offset TransTable
		}
		while(iBitsInHoldArea >= 6)
		{
			__asm
			{
				mov		eax,dwHoldArea
				and		eax,3fh
				xlat
				stosb
				shr		dwHoldArea,6
				sub		iBitsInHoldArea,6
				inc		dwCount64
				inc		dwStuffR64Index
				cmp		dwCount64,64
				jne		L2
				cmp		bDoIntegrity,FALSE
				je		L1
				inc		FileInfoHeader.NUMBER_64_BLOCKS
			L1:	mov		dwCount64,0
				mov		eax,0a0dh
				stosw
				add		dwStuffR64Index,2
			L2:
			}
		}
	}
	// If we have the end of the file, or the out buffer is full.
	//...........................................................
	if (dwFlag == CLOSE || dwStuffR64Index >= BUFFER_SIZE_IN)
	{
		// This section will only be executed on a close if there
		// are any left over bits.
		//.......................................................
		if (dwFlag == CLOSE  && iBitsInHoldArea > 0)
		{
			__asm
			{
				mov		edi,lpR64TempOut
				add		edi,dwStuffR64Index
				mov		ebx,offset TransTable
			}
			while(iBitsInHoldArea > 0)
			{
				__asm
				{
					mov		eax,dwHoldArea
					and		eax,3fh
					xlat
					stosb
					shr		dwHoldArea,6
					sub		iBitsInHoldArea,6
					inc		dwStuffR64Index
					inc		dwCount64
					cmp		dwCount64,64
					jne		L3
					inc		FileInfoHeader.NUMBER_64_BLOCKS
					mov		dwCount64,0
					mov		eax,0a0dh
					stosw
					add		dwStuffR64Index,2
				L3:
				}
			}
		}
		// If required on a close, add a cr, lf to the end of the file.
		//.............................................................
		if (dwFlag == CLOSE && dwCount64)
		{
			FileInfoHeader.LAST_BLOCK_SIZE = dwCount64;

			__asm
			{
				mov		edi,lpR64TempOut
				add		edi,dwStuffR64Index
				mov		eax,0a0dh
				stosw
				add		dwStuffR64Index,2
			}
		}
		// Write the output buffer to disk.
		//.................................
		if (dwStuffR64Index)
		{
			bResult = WriteMyFile((LPTSTR)lpFileName,hFile,lpR64TempOut,dwStuffR64Index,
								   &dwBytesWritten,NULL);
			dwStuffR64Index = 0;
		}
	}
	return(bResult);
}

// ConvertR64ToBinary converts 4 bytes from the in buffer and 
// converts them to three binary bytes. Returns FALSE if i/o error.
//.................................................................
BOOL ConvertR64ToBinary(LPBYTE lpFileName, HANDLE hFile, DWORD dwByteCount, 
						BOOL bCheckIntegrity)
{
	BOOL		bResult = TRUE;
	DWORD		dwNextByte;
	LPBYTE		lpTempPtr;

	lpTempPtr = lpR64TempIn;

	while(dwByteCount != 0)
	{
		EmptyTheMessageQue();
		if (bCancelOperation == TRUE)
		{
			break;
		}
		// Find a valid byte to convert.
		//..............................
		while(TRUE)
		{
			if (*lpTempPtr == '+' || 
			   (*lpTempPtr >= '/' && *lpTempPtr <= '9') ||
			   (*lpTempPtr >= 'A' && *lpTempPtr <= 'Z') ||
			   (*lpTempPtr >= 'a' && *lpTempPtr <= 'z'))
			{
				break;
			}
			dwByteCount--;

			// If we get to zero we have to bail out.
			//.......................................
			if (dwByteCount == 0)
			{
				break;
			}
			lpTempPtr++;
		}
		// Bail out if dwByteCount is 0.
		//..............................
		if (dwByteCount == 0)
		{
			break;
		}
		// Get the byte to convert.
		//.........................
		__asm
		{
			mov		edi,lpTempPtr
			movzx	eax,byte ptr [edi]
			mov		dwNextByte,eax
		}
		bResult = UnStuffR64(lpFileName,hFile,dwNextByte,NORMAL,bCheckIntegrity);
		if (!bResult)
		{
			break;
		}
		dwTotalBytes--;
		if (dwTotalBytes == 0)
		{
			bEndOfRecon = TRUE;
			break;
		}
		dwByteCount--;
		lpTempPtr++;
	}
	return(bResult);
}

// UnStuffR64 converts a byte value back to its original 6 bit value
// via the proper translation table. Returns FALSE if i/o error.
//..................................................................
BOOL UnStuffR64(LPBYTE lpFileName, HANDLE hFile, DWORD dwNextByte, DWORD dwFlag, 
				BOOL bDoIntegrity)
{
	DWORD		dwBytesWritten;
	BOOL		bResult = TRUE;

	if (dwFlag == NORMAL)
	{
		__asm
		{
			mov		edi,lpR64TempOut
			add		edi,dwStuffR64Index
			mov		eax,dwNextByte
			mov		ebx,offset ReconTable
			xlat
			mov		ecx,iBitsInHoldArea
			shl		eax,cl
			or		dwHoldArea,eax
			add		iBitsInHoldArea,6
		}
		while(iBitsInHoldArea >= 8)
		{
			__asm
			{
				mov		al,byte ptr dwHoldArea
				stosb
			}
			// Calculate the crc32 check value.
			//.................................
			if (bDoIntegrity)
			{
				__asm
				{
					xor		al,byte ptr dwCheckCrc
					shr		dwCheckCrc,8
					movzx	edx,al
					mov		esi,lpCrc32Table
					mov		eax,dword ptr [esi][edx*4]
					xor		dwCheckCrc,eax
				}
			}
			__asm
			{
				inc		dwStuffR64Index
				shr		dwHoldArea,8
				sub		iBitsInHoldArea,8
			}
		}
	}
	// Write the buffer to disk if we have to.
	//........................................
	if(dwFlag == CLOSE || dwStuffR64Index >= BUFFER_SIZE_IN)
	{
		if (dwStuffR64Index > 0)
		{
			bResult = WriteMyFile(lpFileName,hFile,lpR64TempOut,
								  dwStuffR64Index,&dwBytesWritten,NULL);
			dwStuffR64Index = 0;
		}
	}
	return(bResult);
}
